*************************************************************************
** An Introduction to Empirical Legal Studies
**  Part IV Replication Files
**
** Revised on 3/17/2014 KEC	  
**
** This work is licensed under a Creative Commons Attribution 4.0
** International License. See http://creativecommons.org/licenses/by/4.0
** for more information.
**
** Authors
**	Lee Epstein, Washington University in St. Louis
**  and Andrew D. Martin, University of Michigan
*************************************************************************

** Part IV

** Figure IV.2 The pie charts on the top depict the type of legal 
**   tradition applicant and respondent countries in cases before the 
**   International Court of Justice. We present the same data on the bottom 
**   with dot plots. The dots plots are superior because they facilitate 
**   lookup of the data patterns; they also ease comparisons within and 
**   between the juxtaposed panels by providing a common baseline
** Section IV, p. 227

** read in data
use icjData.dta

** generate the dot plots
** generate new proportion variables from data 
tabulate appLegalTrad
tabulate respLegalTrad
gen appLegalTradProp = .
replace appLegalTradProp = 33.83 if (appLegalTrad==1)
replace appLegalTradProp = 47.60 if (appLegalTrad==2)
replace appLegalTradProp = 14.88 if (appLegalTrad==3)
replace appLegalTradProp = 1.85 if (appLegalTrad==4)
replace appLegalTradProp = 1.85 if (appLegalTrad==5)
gen respLegalTradProp = .
replace respLegalTradProp = 52.78 if (respLegalTrad==1)
replace respLegalTradProp = 32.47 if (respLegalTrad==2)
replace respLegalTradProp = 1.14 if (respLegalTrad==3)
replace respLegalTradProp = 12.40 if (respLegalTrad==4)
replace respLegalTradProp = 1.22 if (respLegalTrad==5)

** generate left-hand dot plot
graph dot appLegalTradProp, over(appLegalTrad, descending) dots(msize(vtiny)) ///
   yscale(range(0 100)) ylabel(0(25)100, grid glcolor(bluishgray)) ///
   ytitle("Percentage") title(Applicant's Legal Tradition, size(small) ///
   position(12) orientation(horizontal) box fcolor(bluishgray) bexpand) ///
   saving(figIV23, replace)

** generate right-hand dot plot
graph dot respLegalTradProp, over(respLegalTrad, descending) ///
   dots(msize(vtiny)) yscale(range(0 100)) ylabel(0(25)100, grid ///
   glcolor(bluishgray)) ytitle("Percentage") title(Respondent's Legal ///
   Tradition, size(small) position(12) orientation(horizontal) box ///
   fcolor(bluishgray) bexpand) saving(figIV24, replace)

** combine dot plots into one figure
graph combine figIV23.gph figIV24.gph, fxsize(150) fysize(80) ///
   title("The Type of Legal Tradition in Applicant and Respondent Countries" ///
   "in Cases before the ICJ", size(small))

** file cleanup
erase figIV23.gph
erase figIV24.gph
