*************************************************************************
** An Introduction to Empirical Legal Studies
** 	Chapter 9 Replication File
**
** Revised on 3/21/2014 KEC	  
**
** This work is licensed under a Creative Commons Attribution 4.0
** International License. See http://creativecommons.org/licenses/by/4.0
** for more information.
**
** Authors
**	Lee Epstein, Washington University in St. Louis
**  and Andrew D. Martin, University of Michigan
*************************************************************************

** Chapter 9

** read in data and install packages
use ictData.dta, clear
ssc install parmest 
ssc install egenmore

** Table 9.1 Multiple regression analysis of sentence 
**   length (in months)
** Section 9.1, p. 198

** Model 1
** keep only the guilty pleas in the verdict variable
drop if missing(verdict)
keep if verdict==1

** drop missing data from the relevant variables and run regression 
drop if missing(genocide) | missing(crimAg) | missing(mfTotal) | missing(afTotal)
regress sentence numGuil

** Model 2
regress sentence  numGuil genocide crimAg mfTotal afTotal

** Figure 9.1 Nomogram of multiple regression parameters and 95% 
**   confidence interval for analysis of sentence length (in months) 
**   in Table 9.1 (Model 2). The dots show the regression parameter 
**   estimates and the horizontal lines show the 95% confidence intervals
** Section 9.1, p. 204

parmest, norestore
egen axis= axis(estimate)
twoway scatter axis estimate, mcolor(black) xline(0, ///
   lcolor(black)) ylab(, angle(horizontal)) ||  rcap min95 ///
   max95 axis, horizontal lcolor(black) ylabel(1 "Number Guilty" 2 ///
   "Number of Aggravating Factors" 3 "Number of Mitigating Factors" ///
   4 "Intercept" 5 "Crimes Against Humanity" 6 "Genocide", labels) ///
   xscale(range(-50 250)) xlabel(0(100)200, grid glcolor(bluishgray)) ///
   xtitle("Multiple Regression Coefficient") ytitle("Independent Variable") ///
   title("Nomogram of multiple regression" ///
   "parameters and 95% confidence interval", size(medium)) legend(off)

** Figure 9.5 Scatterplot of the votes of ICJ judge per capita gross 
**   domestic product of the judge's country, with a regression line
** Section 9.3, p. 214

** read in data
use icjData_10.dta, clear
gen jGDP = judgeGDP/10000
drop if missing(decision1) | missing(jGDP)
twoway (scatter decision1 jGDP, mcolor("128 128 128") msymbol(circle_hollow)) ///
   (lfit decision1 jGDP, lcolor(black)), ytitle(Judge Rules in Favor of ///
   Applicant) ylabel(0.00(0.25)1.00, grid glcolor(bluishgray) ///
   angle(horizontal)) xtitle(Judge Per Capita GDP ($10,000 in 1996)) ///
   xscale(range(0 3.8)) xlabel(0(1)3, grid glcolor(bluishgray)) ///
   title("Scatterplot of votes of ICJ judge" ///
   "per capita GDP with regression line", size(medium)) legend(off)

** Table 9.2 Logistic regression analysis of the votes of ICJ 
**   judges on per capita gross domestic product of the judge's country
** Section 9.3, p. 216
logit decision1 jGDP

** Figure 9.7 Predicted probabilities of an ICJ judge vote in 
**   favor of petitioning country as a function of per capita judge 
**   GDP, based on estimates in Table 9.2. The grey region denotes 95% 
**   confidence interval 
** Section 9.3, p. 219

** requres Clarify
net from http://gking.harvard.edu/clarify
net install clarify

** set up ruler and loop to get highs and lows
set obs 3801  
estsimp logit decision1 jGDP, sims(3801) 
set more off
gen tops = .
gen bottoms = .
gen ruler = _n*0.001-0.001 in 1/3801
local jGDPpred = 0
while `jGDPpred' <= 3.8 {
  display "Simulating for jGDP = `jGDPpred'"
  setx jGDP `jGDPpred'
  simqi, prval(1) genpr(probs)
  _pctile probs, p(2.5,97.5)
  replace bottoms = r(r1) if ruler==float(`jGDPpred')  
  replace tops = r(r2) if ruler==float(`jGDPpred')      
  drop probs
  local jGDPpred = `jGDPpred'+0.001
}
** create the figure
gen coef = _b[jGDP]
gen cons = _b[_cons]
gen logitPred = invlogit(cons+coef*ruler)
twoway (rspike tops bottoms ruler, lcolor(gs13)) ///
   (line logitPred ruler, lcolor(black)), ytitle(Judge ///
   Rules in Favor of Applicant) ylabel(0.2(0.1)0.6, ///
   grid glcolor(bluishgray) angle(horizontal)) xtitle(Judge Per ///
   Capita GDP ($10,000 in 1996))  xscale(range(0 3.8)) ///
   xlabel(0(1)3, grid glcolor(bluishgray)) ///
   title("Predicted Probabilties of an ICJ judge vote in favor of plaintiff" ///
   "as a function of percapita judge GDP", size(medium)) legend(off) 
