*************************************************************************
** An Introduction to Empirical Legal Studies
** 	Chapter 8 Replication Files
**
** Revised on 3/21/2014 KEC	  
**
** This work is licensed under a Creative Commons Attribution 4.0
** International License. See http://creativecommons.org/licenses/by/4.0
** for more information.
**
** Authors
**	Lee Epstein, Washington University in St. Louis
**  and Andrew D. Martin, University of Michigan
*************************************************************************

** Chapter 8

** Figure 8.3
** Scatterplot of sentence length on number of guilty counts
** Section 8.2, p. 179

** read in data
use ictData.dta, clear

** keep only the guilty pleas 
drop if missing(verdict)
keep if verdict==1

** make the scatterplot
twoway (scatter sentence numGuil, mcolor(gs10) msymbol(circle)), ///
   yscale(range(0 700)) ylabel(0(200)600, grid glcolor(bluishgray) ///
   angle(horizontal)) xlabel(, grid glcolor(bluishgray)) ytitle(Sentence ///
   (months)) xtitle(Number of Guilty Counts) ///
   title("Scatterplot of sentence length" "on the number of guilty counts", size(medium))  

** Figure 8.4 Scatterplot of sentence length on number of guilty counts 
**   with linear regression line, estimated using ordinary least squares
** Section 8.2, p. 179

** make the scatterplot
twoway (scatter sentence numGuil, mcolor(gs10) msymbol(circle)) ///
   (lfit sentence numGuil, lcolor(black)), yscale(range(0 700)) ///
   ylabel(0(200)600, grid glcolor(bluishgray) angle(horizontal)) ///
   xlabel(, grid glcolor(bluishgray)) ytitle(Sentence (months)) ///
   xtitle(Number of Guilty Counts) ///
   title("Scatterplot of sentence length on the number of guilty counts" ///
   "with linear regression line", size(medium)) legend(off)

** Table 8.1
** Linear regression of sentence length (in months) on the number of 
**   guilty counts
** Section 8.3, p. 184

regress sentence numGuil

** Figure 8.7 Prediction plot for linear regression of sentence 
**   length (in months) on the number of guilty counts. Grey region 
**   shows 95% confidence interval for the expected value
** Section 8.3, p. 189

** make the scatterplot
twoway (lfitci sentence numGuil, fcolor(gs12)) (scatter sentence ///
   numGuil, mcolor(gs10) msymbol(circle)), yscale(range(0 800)) ///
   ylabel(0(250)750, grid glcolor(bluishgray) angle(horizontal)) ///
   xlabel(, grid glcolor(bluishgray)) ytitle(Sentence (months)) ///
   xtitle(Number of Guilty Counts) ///
   title("Scatterplot of sentence length" "on the number of guilty counts" ///
   "with linear regression line and 95% confidence interval", ///
   size(medium))  legend(off)
