*************************************************************************
** An Introduction to Empirical Legal Studies
** 	Chapter 10 Replication Files
**
** Revised on 3/21/2014 KEC	  
**
** This work is licensed under a Creative Commons Attribution 4.0
** International License. See http://creativecommons.org/licenses/by/4.0
** for more information.
**
** Authors
**	Lee Epstein, Washington University in St. Louis
**  and Andrew D. Martin, University of Michigan
*************************************************************************

** Chapter 10

** Table 10.1 Roe's regression of ownership on politics. * indicates p 
**   less than or equal to .01. Standard errors in parentheses. The dependent 
**   variable is the propoortion of firms under diffuse ownership 
**   in the 16 richest nations; the independent variable is expert 
**   assessment of the nations' politics (from most left-wing to 
**   most right-wing)
** Section 10.1, p. 234

** read in data
use roe.dta, clear
reg firms politics

** Figure 10.1 Dot plots of the length (in words) of present-day 
**   constitutions in 41 countries, by European region. If the goal 
**   is to provide readers with exact figures, Table 10.3 is the better 
**   display. If the goal is convey patterns or trends, as it usually 
**   is, we prefer this figure to Table 10.3
** Section 10.1, p. 243

** read in data
use ccpCharacteristics.dta, clear
replace country_new = "Macedonia" in 99

** make the figure
graph dot length_n, over(country_new, label(labsize(vsmall)) sort(1)) nofill ///
   by(, title("Dot Plots of the Length of Constitutions in 41 European Countries" ///
   "by European Regions", size(small))) by(europe, col(1)) ///
   ylabel(, grid glcolor(bluishgray)) subtitle(,position(3) ///
   orientation(rvertical) size(vsmall)) ytitle("Length of Constitutions", ///
   size(small)) xsize(4) ysize(6) 

** Figure 10.2 Length (in words) of present-day constitutions in countries 
**   in Southern Europe.  Although it is possible from the table to 
**   observe the patterns that jump out in the graph--for example, 
**   the large difference between the shortest and longest 
**   constitutions--it requires far more (unnecessary) cognitive work
** Section 10.1, p. 245

** requires data from previous figure
gen str ccpSEurope="Southern Europe" if europe==3
drop if missing(ccpSEurope)

** make the figure
graph dot length_n, over(country_new, sort(1)) ylabel(, grid ///
   glcolor(bluishgray)) title("Length of Present-Day Constitutions" ///
   "in Countries in Southern Europe") ytitle("Length of Constitutions")

** Figure 10.4 Both panels depict the mean life expectancy at birth 
**   (in years) in five regions, by gender. The bottom panel reflects 
**   our attempt to reduct clutter. Specifically, we elimiated (1) 
**   the depth cue, (2) the internal data labels, (3) tick marks 
**   on the horizontal axis, and (4) the legend.  We also reducted 
**   the number of tick marks on the vertical axis and supplanted 
**   the cross hatching with a solid color. The result is a graph far 
**   easier to decode
** Section 10.2, p. 249

** read in data
use lifeExpectancyWorld.dta, clear

** generate the top panel 
graph bar (mean) female_life (mean) male_life, over(continent) ///
   blabel(bar, format(%4.2f)) ytitle(Average Life Expectancy) ///
   ytitle(, orientation(vertical) justification(left)) yscale(range(0 85)) ///
   ylabel(#17, labsize(small) angle(horizontal)) legend(on order(1 ///
 "Females" 2 "Males")) saving(fig1041, replace)

** generate the bottom panel
graph hbar (mean) female_life, over(continent, descending) ylabel(50(10)80, ///
   grid glcolor(bluishgray)) title(Females, box fcolor(bluishgray) bexpand) ///
   ytitle("") exclude0 saving(fig1042, replace)
graph hbar (mean) male_life, over(continent, descending) ylabel(50(10)80, ///
   glcolor(bluishgray)) title(Males, box fcolor(bluishgray) bexpand) ytitle("") ///
   exclude0 saving(fig1043, replace)
graph combine fig1042.gph fig1043.gph, caption(Average of Expectancy, ///
   position(6)) saving(fig1044, replace)

** combine top and bottom panel into one figure
graph combine fig1041.gph fig1044.gph, title(The Mean Life Expectancy ///
   in Five Regions, size(small)) col(1)

** Figure 10.5 Both panels depict the number of criminal and civil 
**   cases filed per authorized judgeship in the U.S. Court of Appeals, 
**   1992-2010. The bottom panel reflects our attempt to improve 
**   visualization of the data. Specifically, we eliminated the legend 
**   (replacing it with internal data labels) and the dark grid, both 
**   of which obscure the data. Finally, we supplanted the non-circular 
**   subelements with circular connectors, though if the author's purpose 
**   is merely to show trends in new filings, the circles may be unnecessary
** Section 10.2, p. 250

** read in data
use simons.dta, clear

** generate the top panel
twoway (connected civil year) (connected criminal year), ///
   ytitle(Cases Filed Per Authorized Judgeship, size(small)) ///
   yscale(range(0 30000)) ylabel(0(5000)30000, labsize(vsmall) ///
   angle(horizontal) grid glwidth(vvthin) glcolor(black)) ///
   xtitle(Year) xlabel(1992(1)2010, labsize(vsmall)) legend(on cols(1) ///
   position(4) ring(0)) saving(fig1051, replace)

** generate the bottom panel
twoway (connected civil year, mcolor(black) msymbol(circle) ///
   lcolor(black) lwidth(medium)) (connected criminal year, ///
   mcolor(black) msymbol(circle_hollow) lcolor(black) lwidth(thin)), ///
   ytitle(Cases Filed per Authorized Judgeship, size(small)) ///
   ylabel(10000(5000)25000, labsize(vsmall) angle(horizontal) ///
   glcolor(bluishgray)) xtitle(Year) xlabel(1990(5)2013, grid ///
   glcolor(bluishgray)) text(13000 2011.5 "Criminal" 19500 2011 "Civil") ///
   legend(off) saving(fig1052, replace)

** combine top panel and the bottom panel into one figure
graph combine fig1051.gph fig1052.gph, ///
   title("Number of Criminal and Civil Cases Filed" ///
   "per Authorized Judgeship in the U.S. Courts of Appeals", ///
   size(small)) col(1)

** Figure 10.6 Dot plots of the length (in words) of present-day 
**   constitutions in Eastern Europe. From the top panel is it difficult 
**   to observe serveral potentially interesting patterns in the data, 
**   such as the gap between Bulgaria and Hungary. We excluded zero in 
**   the bottom panel to facilititae a more effective judgment about the data
** Section 10.2, p. 254

** read in data and generate variables
use ccpCharacteristics.dta, clear
gen str ccpEEurope="Eastern Europe" if europe==1
drop if missing(ccpEEurope)

** generate the top panel 
graph dot length_n, over(country_new, sort(1)) ylabel(, ///
   grid glcolor(bluishgray)) ytitle("") saving(fig1061, replace)

** generate the bottom panel
graph dot length_n, over(country_new, sort(1)) ylabel(, ///
   grid glcolor(bluishgray)) ytitle("Length of Constitutions") ///
   exclude0 saving(fig1062, replace)

** combine top panel and bottom panel into one figure
graph combine fig1061.gph fig1062.gph, col(1) ///
   title("Length of Present-Day Constitutions" "in Countries in Eastern Europe", ///
   size(medium))

** Figure 10.7 All three panels show the Trust in Government Index 
**   (developed from the American National Election Studies) on the 
**   vertical axis and year (from 1958-2008) on the horizontal axis.
**   From the top panel it is difficult to observe the decline in 
**   trust over time. We excluded zero in the middle pattern to 
**   facilitate a more effective judgment about the data, and did 
**   not connect 1958 to 1964 to accentuate data sparseness. A problem 
**   in both the top and middle panels, however, is that neither clearly 
**   delineates missing years. To fix it, we moved to a bar chart. 
**   Now readers can spot missing data, and it is also easier to see 
**   that the Index is available only for even-numbered years. 
**   The sequence of charts shores up Cleveland's advice: 
**   "Don't hesitate to make two or more graphs of the same data."
** Section 10.2, p. 256

** read in data
use schroeder.dta, clear

** generate the top panel
twoway (connected value year, mcolor(black) msymbol(square) ///
   lcolor(black)), ylabel(0(10)70, nogrid) ylabel(, labsize(small) ///
   angle(horizontal)) xlabel(1958(2)2008, labsize(vsmall) nogrid) ///
   xtitle("") ytitle("") saving(fig1071, replace)

** generate the middle panel
twoway (connected value year, mcolor(black) msymbol(circle) ///
   lcolor(black) cmissing(n)), ylabel(30(10)60, labsize(small) ///
   angle(horizontal) grid glcolor(midblue) glpattern(vshortdash)) ///
   xlabel(1960(10)2010, labsize(vsmall) nogrid) xtitle("") ytitle("""") ///
   saving(fig1072, replace)

** generate the bottom panel
graph bar (mean) value, over(year, label(labcolor(black) ////
   labsize(vsmall))) missing bar(1, fcolor(black)) ylabel(0(20)60, ///
   labsize(small) angle(horizontal) glcolor(midblue) glpattern(vshortdash)) ///
   ytitle("") saving(fig1073, replace)

** combine all three panels into one figure
graph combine fig1071.gph fig1072.gph fig1073.gph, col(1) title(Trust ///
   in Government Index 1958-2008, size(small))

** clean up files
erase fig1041.gph
erase fig1042.gph
erase fig1043.gph
erase fig1044.gph
erase fig1051.gph
erase fig1052.gph
erase fig1061.gph
erase fig1062.gph
erase fig1071.gph
erase fig1072.gph
erase fig1073.gph
