##########################################################################
## An Introduction to Empirical Legal Studies
## 	Part IV Replication File
##
## Revised on 3/21/2014 KEC	  
##
## This work is licensed under a Creative Commons Attribution 4.0
## International License. See http://creativecommons.org/licenses/by/4.0
## for more information.
##
## Authors
##	Lee Epstein, Washington University in St. Louis
##  and Andrew D. Martin, University of Michigan
##########################################################################


## load packages and set up multiplot 
library(foreign)
library(ggplot2)
library(reshape)
library(grid) 
source("ggplotTemplate.R")

multiplot <- function(..., plotlist=NULL, file, cols=1, layout=NULL) {
  require(grid)

  # Make a list from the ... arguments and plotlist
  plots <- c(list(...), plotlist)

  numPlots = length(plots)

  # If layout is NULL, then use 'cols' to determine layout
  if (is.null(layout)) {
    # Make the panel
    # ncol: Number of columns of plots
    # nrow: Number of rows needed, calculated from # of cols
    layout <- matrix(seq(1, cols * ceiling(numPlots/cols)),
                    ncol = cols, nrow = ceiling(numPlots/cols))
  }

 if (numPlots==1) {
    print(plots[[1]])

  } else {
    # Set up the page
    grid.newpage()
    pushViewport(viewport(layout = grid.layout(nrow(layout), ncol(layout))))

    # Make each plot, in the correct location
    for (i in 1:numPlots) {
      # Get the i,j matrix positions of the regions that contain this subplot
      matchidx <- as.data.frame(which(layout == i, arr.ind = TRUE))

      print(plots[[i]], vp = viewport(layout.pos.row = matchidx$row,
                                      layout.pos.col = matchidx$col))
    }
  }
}
## Figure IV.2 The pie charts on the top depict the type of legal tradition in
## applicant and respondent countries in cases before the International Court of 
## Justice. We present the same data on the bottom with the dot plots. The dot plots 
## are superior because they facilitate lookup of the data patterns; they also ease 
## comparisons within and between the juxtaposed panels by providing a common baseline
## Part IV, p. 227

## read in data
icj <- read.dta("icjData.dta")
tabALT <- table(icj$appLegalTrad)
dfALT <- data.frame(jlt= tabALT[]/sum(tabALT[])*100, names=names(tabALT))
tabRLT <- table(icj$respLegalTrad)
dfRLT <- data.frame(jlt= tabRLT[]/sum(tabRLT[])*100, names=names(tabRLT))

## read in data from pie charts
pieData <- read.table(header=T, text='
type      jlt        names
Applicant 33.825338      English
Applicant 47.601476       French
Applicant 14.883149       German
Applicant  1.845018 Scandinavian
Applicant  1.845018    Socialist
Respondent 52.775665      English
Respondent 32.471483       French
Respondent 1.140684       German
Respondent 12.395437 Scandinavian
Respondent  1.216730    Socialist
')
pieData$names <- factor(pieData$names,levels=c("English","French","German",
                                               "Scandinavian","Socialist"),
                        labels=c("English","French","German","Scandinavian",
                                 "Socialist"),ordered=T)
pieData$type <- factor(pieData$type,levels=c("Applicant","Respondent"),
                       labels=c("Applicant's Legal Tradition",
                                "Respondent's Legal Tradition"))
## dotplot
dotplot <- ggplot(pieData, aes(x=jlt, y=names)) + geom_point(size=3) +
  geom_hline(yintercept=1, linetype=3) +
  geom_hline(yintercept=2, linetype=3) +
  geom_hline(yintercept=3, linetype=3) +
  geom_hline(yintercept=4, linetype=3) +
  geom_hline(yintercept=5, linetype=3) + xlim(0,100) + xlab("Percentage") + 
  ylab("")+ facet_wrap( ~ type, ncol=2)

## show plot and save it
print(dotplot)
ggsave("dotplot.pdf", dotplot, height=3, width=5.2)
