##########################################################################
## An Introduction to Empirical Legal Studies
## 	Chapter 6 Replication File
##
## Revised on 3/21/2014 KEC	  
##
## This work is licensed under a Creative Commons Attribution 4.0
## International License. See http://creativecommons.org/licenses/by/4.0
## for more information.
##
## Authors
##	Lee Epstein, Washington University in St. Louis
##  and Andrew D. Martin, University of Michigan
##########################################################################

## Chapter 6

## load pacakges
library(ggplot2)
library(foreign)
source("ggplotTemplate.R")

## Figure 6.2 Histogram of sentence length (Sentence Length) for convicted
## defendants 
## Section 6.3, p. 128

## read in data
ict <- read.dta("ictData.dta")

## make the histogram
## options xlim=c()
histogram <- ggplot(ict, aes(x=sentence)) + geom_histogram(binwidth=40, 
 fill=fillColor)
histogram <- histogram + xlab("Sentence (month)") + ylab("Count") + xlim(0,640)

## show plot and save it
print(histogram)
ggsave("histogram.pdf", histogram, height=5, width=5)


## Figure 6.3 Illustration of symmetric and skewed distributions. The top panel
## is an example of a symmetric distribution; the second panel is left skewed 
## and the third, right skewed
## Section 6.3, p. 130

## set up ruler for the Beta distribution
ruler <- seq(0,1,0.005)

## pull together betaDensities for skewed plot
betaDensitySkew <- data.frame(x=rep(ruler,3), y=c(dbeta(ruler, 5.5, 5.5),
                                              dbeta(ruler, 6, 3),
                                              dbeta(ruler, 3, 6)),
                          type=ordered(c(rep("Symmetric", length(ruler)),
                                           rep("Left Skewed", length(ruler)),
                                           rep("Right Skewed", length(ruler))),
                          levels=c("Symmetric", "Left Skewed", "Right Skewed")))

skewPlot <- ggplot(data=betaDensitySkew, aes(x, y)) + geom_line(size=lineSize)
skewPlot <- skewPlot + facet_wrap(~type, ncol=1) + ylim(0,2.7) + xlim(0,1) + 
  ylab("Density") 

## show plot ans save it
print(skewPlot)
ggsave("skewPlot.pdf", skewPlot, height=5, width=9)


## Figure 6.4 An illustration of two distributions, one more dispersed (top 
## panel) and one less dispersed (bottom panel)
## Section 6.3, p. 131

## pull together betaDensities for dispersion plot
betaDensityDisp <- data.frame(x=rep(ruler,2), y=c(dbeta(ruler, 3, 3),
                                                  dbeta(ruler, 10, 10)),
                              type=ordered(c(rep("More Dispersed", length(ruler)),
                                             rep("Less Dispersed", length(ruler))),
                                           levels=c("More Dispersed", 
                                                    "Less Dispersed")))

dispPlot <- ggplot(data=betaDensityDisp, aes(x, y)) + geom_line(size=lineSize)
dispPlot <- dispPlot + facet_wrap(~type, ncol=1) + ylim(0,3.6) + xlim(0,1) + 
  ylab("Density")

## show plot and save it
print(dispPlot)
ggsave("dispPlot.pdf", dispPlot, height=7, width=5)

## Figure 6.5 Three different normal distributions. The top panel has a mean of 
## zero and a standard deviation of one. The middle panel has a mean of two and 
## a standard deviation of one. The bottom panel has a mean of zero and a standard 
## deviation of one.
## Section 6.5, p. 141 

## set up ruler for the Normal distribution
ruler <- seq(-5,5,0.005)

## pull together betaDensities for skewed plot
normalDensity <- data.frame(x=rep(ruler,3), y=c(dnorm(ruler, 0, 1),
                                                dnorm(ruler, 2, 1),
                                                dnorm(ruler, 0, 2)),
                              type=ordered(c(rep("Normal(0,1)", length(ruler)),
                                             rep("Normal(2,1)", length(ruler)),
                                             rep("Normal(0,2)", length(ruler))),
                                           levels=c("Normal(0,1)", "Normal(2,1)", 
                                                    "Normal(0,2)")))

normalPlot <- ggplot(data=normalDensity, aes(x, y)) + geom_line(size=lineSize) + 
  ylim(0,0.4)
normalPlot <- normalPlot + facet_wrap(~type, ncol=1) + xlim(-5,5) + ylab("Density")

## show plot and save it
print(normalPlot)
ggsave("normalPlot.pdf", normalPlot, height=10, width=5)

## Figure 6.6 Illustration of the empirical rule. Y-bar denotes the sample mean. 
## s denotes the sample standard deviation
## Section 6.5, p. 143

## set up ruler for the Normal distribution
ruler <- seq(-3.5,3.5,0.005)

## data
typeHolder <- rep("a", length(ruler))
typeHolder[ruler > -2 & ruler <= -1] <- "b"
typeHolder[ruler > 1 & ruler <= 2] <- "b"
typeHolder[ruler > -1 & ruler <= 1] <- "c"
normalDensity <- data.frame(x=ruler, y=dnorm(ruler), type=ordered(typeHolder))

## create the plot
empiricalRule <- ggplot(data=normalDensity, aes(x, y, fill=type)) + 
  geom_line(size=lineSize)
empiricalRule <- empiricalRule + scale_x_continuous(breaks=c(-3, -2, -1, 0, 1, 2, 3),
                                                    labels=c(expression(bar(Y)- 3 * s),
                                                             expression(bar(Y)- 2 * s),
                                                             expression(bar(Y)- s),
                                                             expression(bar(Y)),
                                                             expression(bar(Y)+ s),
                                                             expression(bar(Y)+ 2 * s),
                                                             expression(bar(Y)+ 3 * s)))  

empiricalRule <- empiricalRule + ylab("Density")
empiricalRule <- empiricalRule + geom_area()
empiricalRule <- empiricalRule + guides(fill=FALSE)
empiricalRule <- empiricalRule + scale_fill_manual(values=c("grey70", "grey50", 
                                                            "grey30"))
empiricalRule <- empiricalRule + annotate("text", 1.2, 0.3, label="68%", 
                                          family=myFont)
empiricalRule <- empiricalRule + annotate("text", 1.9, 0.15, label="95%", 
                                          family=myFont)
empiricalRule <- empiricalRule + annotate("text", 2.8, 0.04, label="99.7%", 
                                          family=myFont)

## show plot and save it
print(empiricalRule)
ggsave("empiricalRule.pdf", empiricalRule, height=5, width=6)
