##########################################################################
## An Introduction to Empirical Legal Studies
## 	Chapter 2 Replication File
##
## Revised on 3/21/2014 KEC	  
##
## This work is licensed under a Creative Commons Attribution 4.0
## International License. See http://creativecommons.org/licenses/by/4.0
## for more information.
##
## Authors
##	Lee Epstein, Washington University in St. Louis
##  and Andrew D. Martin, University of Michigan
##########################################################################

## Chapter 2

## load packages
library(ggplot2)
library(foreign)
source("ggplotTemplate.R")

## Figure 2.1 Fraction of U.S. Supreme Court cases with at least one 
## dissenting opinion, 1801-2011
## Section 2.1, p. 25

## read in data
data <- read.dta("dissent.dta")

## create the lineplot
dissent <- ggplot(data, aes(x=term, y=dissents)) + geom_line(size=lineSize)
dissent <- dissent + xlab("Term") + ylab("Fraction")

## show plot and save it
print(dissent)
ggsave("dissent.pdf", dissent, height=5, width=9)
